/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.panel;

import cofh.core.client.gui.CoreTextures;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementAugmentSlots;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.inventory.container.slot.SlotCoFH;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class AugmentPanel
extends PanelBase {
    public static int defaultSide = 1;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0x101010;
    public static int defaultBackgroundColor = 564812;
    private final int slotsBorderX1 = 18;
    private final int slotsBorderX2 = 78;
    private final int slotsBorderY1 = 20;
    private final int slotsBorderY2 = 80;

    public AugmentPanel(IGuiAccess gui, @Nonnull IntSupplier numSlots, @Nonnull List<SlotCoFH> augmentSlots) {
        this(gui, defaultSide, numSlots, augmentSlots);
    }

    protected AugmentPanel(IGuiAccess gui, int sideIn, @Nonnull IntSupplier numSlots, @Nonnull List<SlotCoFH> augmentSlots) {
        super(gui, sideIn);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 102;
        this.addElement(new ElementAugmentSlots(gui, 24, 24, numSlots, augmentSlots));
    }

    @Override
    protected void drawForeground(PoseStack matrixStack) {
        this.drawPanelIcon(matrixStack, CoreTextures.ICON_AUGMENT);
        if (!this.fullyOpen) {
            return;
        }
        this.getFontRenderer().m_92750_(matrixStack, StringHelper.localize("info.cofh.augmentation"), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
        RenderHelper.resetShaderColor();
    }

    @Override
    protected void drawBackground(PoseStack poseStack) {
        super.drawBackground(poseStack);
        if (!this.fullyOpen) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        RenderHelper.setPosTexShader();
        RenderSystem.m_157429_((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.drawTexturedModalRect(poseStack, this.sideOffset() + 18, 20, 16, 20, 60, 60);
        RenderHelper.resetShaderColor();
    }

    @Override
    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        if (!this.fullyOpen) {
            tooltipList.add((Component)new TranslatableComponent("info.cofh.augmentation"));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.fullyOpen) {
            return false;
        }
        double x = mouseX - (double)this.posX();
        double y = mouseY - (double)this.posY();
        return x >= (double)(18 + this.sideOffset()) && x < (double)(78 + this.sideOffset()) && y >= 20.0 && y < 80.0;
    }
}

